;
; BBS.cmd  -  simple Bulletin Board emulation for ProComm v 2.4.2
;
; Written by Vernon E. Davis    06/01/87
;            17 Bowen Avenue
;            Woodstown, NJ 08098
;
;            CompuServe [71330,2705]
;            Source     BEQ304
;
; Description of program
; ----------------------
; BBS.cmd is a command file for ProComm  v 2.4.2 that sets up a Bulletin
; board capable of transfering files and leaving or sending messages.
; It supports up to 10 users, each having a unique password. It is fully
; operational on its own and requires no systems operator ( SYSOP ) to
; monitor it. The three file transfer protocols supported are Xmodem, ASCII
; and Kermit. This program was written as a template to provide limited
; BBS emulation. It cannot replace the power of full-fledged BBS programs.
; Those who do not have ProComm  v 2.4.2 can download the program from
; practically any BBS. It is an excellent shareware communications program
; with a minimum registration fee of $25.00. I am not requesting a donation
; for this program. However, comments and suggestions would be appreciated.
;
; Program Flow
; ------------
; 1. Setup communication parameters
; 2. Wait for Carrier Detect
; 3. Get Username and Password
; 4. If there is a match, continue with program ( item # 7 )
; 5. If there is no match, try again.
; 6. If there is no match after three tries, hangup and reset program
;    ( item # 2 )
; 7. Display Username and Welcome message
; 8. Display Message Of The Day ( MOTD ) and/or user-specific messages
; 9. MENUs
;
; ***  WARNING !!!  The variables used in the procedures below are
; S6, S7, S8 and S9. Be sure not to use them in your own subroutines
; because the data integrity cannot be assured.
;
; Variable Assignments
; --------------------
; S0 to S5    - free, not used
; S6 to S9    - system variables
;
; NOTE: this program assumes that the string CR/LF character is an
;       exclamation point ( ! ).
;
;
Setup:
GoSub SetCommParam
;
; the GoSub routine "SetCommParam" sets the proper communication
; parameters. Since this program was developed using two PC's,
; the Set commands will probably not reflect the proper values.
; Change these commands and/or add your own.
;
; ****   The BBS program starts here. ****
;
StartOfSession:
;
; wait for Carrier Detect
; NOTE: your Carrier Detect must not held high. See the ProComm
; documentation for details (Chapter 8 - Command Files)
;
If Connected
Else
   GoTo StartOfSession
EndIf
GoSub Login
;
; change the following Assign S9 statement for welcome to BBS
; It previously contains the word "OK" if login was successful.
;
Assign S9 "!"
GoSub LoginOK
;
; the GoSub routine "OpeningStatement" will allow a MOTD
; (message of the day) to appear. It is currently written
; to display user-specific messages.
;
GoSub OpeningStatement
GoTo MainMenu

SetCommParam:
Set Port COM1
Set Baudrate 9600
Set Databits 8
Set Duplex Half
Set Parity None
Set CR_IN  CR_LF
Set CR_OUT CR_LF
Set FlowCtrl On
Set Alarm Off
Set Sound Off
Set ASCII LinePace 1
Set ASCII Echo On
Return

CheckUsers:
; each of the ten Case statements that follow contain a Username
; and password. The limitations of ProComm do not allow the user
; to change his/her password from the remote terminal. The variable
; S6, which holds the Username, is set for 8 characters maximum.
; The variable S7, which holds the password, is set for 20 characters
; maximum. They can both be reset for up to 80 characters.
;
; The Case "xxxxxx"    statement is the Username.
; The Find S7 "xxxxxx" statement is the Password.
;
Switch S6
   ; User # 0
   Case "VERNON"
      Find S7 "VED"
      If Found
         Assign S9 "OK"
         Return
      EndIf
   EndCase
   ; User # 1
   Case "******"
      Find S7 "******"
      If Found
         Assign S9 "OK"
         Return
      EndIf
   EndCase
   ; User # 2
   Case "******"
      Find S7 "******"
      If Found
         Assign S9 "OK"
         Return
      EndIf
   EndCase
   ; User # 3
   Case "******"
      Find S7 "******"
      If Found
         Assign S9 "OK"
         Return
      EndIf
   EndCase
   ; User # 4
   Case "******"
      Find S7 "******"
      If Found
         Assign S9 "OK"
         Return
      EndIf
   EndCase
   ; User # 5
   Case "******"
      Find S7 "******"
      If Found
         Assign S9 "OK"
         Return
      EndIf
   EndCase
   ; User # 6
   Case "******"
      Find S7 "******"
      If Found
         Assign S9 "OK"
         Return
      EndIf
   EndCase
   ; User # 7
   Case "******"
      Find S7 "******"
      If Found
         Assign S9 "OK"
         Return
      EndIf
   EndCase
   ; User # 8
   Case "******"
      Find S7 "******"
      If Found
         Assign S9 "OK"
         Return
      EndIf
   EndCase
   ; User # 9
   Case "******"
      Find S7 "******"
      If Found
         Assign S9 "OK"
         Return
      EndIf
   EndCase
EndSwitch
Assign S9 "BAD"
Return

OpeningStatement:
;
; the routine looks for a text file with the same name as the user
; who is logged in. If it is found, it is sent as an ASCII transfer.
; This allows you to send user-specific messages.
;
IsFile S6
If Success
   SendFile ASCII S6
EndIf
Transmit "!Press any key to begin ..."
If Connected
Else
   GoTo EndOfComm
EndIf
RGet S6 1 120
If Failure
   GoTo TimeOut
EndIf
Return

Login:
;
; the routine prompts the user for a Username and a password. It then
; calls another subroutine to check all qualified users. If found,
; the program continues. If NOT found, the user is prompted again.
; After three tries the routine aborts.
;
Assign S8 "pass 1"
Transmit "! ! ! ! ! ! ! ! ! !CONNECTION ESTABLISHED! !"
;
LoginLoop:
Transmit "!Username : "
If Connected
Else
   GoTo EndOfComm
EndIf
RGet S6 8 60
If Failure
   GoTo TimeOut
EndIf
Transmit "!Password : "
If Connected
Else
   GoTo EndOfComm
EndIf
RGet S7 20 60
If Failure
   GoTo TimeOut
EndIf
GoSub CheckUsers
Find S9 "OK"
If Found
   Return
Else
   Switch S8
      Case "pass 1"
         Assign S8 "pass 2"
         GoTo TryAgain
      EndCase
      Case "pass 2"
         Assign S8 "pass 3"
         GoTo TryAgain
      EndCase
      Case "pass 3"
         GoTo TimeOut
      EndCase
   EndSwitch
EndIf
;
TryAgain:
Transmit "!Invalid login ...!"
GoTo LoginLoop

LoginOK:
; erase password from S7
Assign S7 " "
Transmit "! !Welcome "
Transmit S6
Transmit "!"
Transmit S9
Return

MainMenu:
Transmit "! ! ! ! ! ! ! ! ! !"
Transmit "! ! ! ----- M A I N   M E N U -----! !"
Transmit " 1. Directory of Files!"
Transmit " 2. Download Files!"
Transmit " 3. Upload Files!"
Transmit " 4. Leave a Message with SYSOP!"
Transmit " 5. Log Out!"
Transmit " ?. HELP! !"
Transmit " Make a selection -> "
If Connected
Else
   GoTo EndOfComm
EndIf
RGet S6 1 240
Transmit "!"
If Failure
   GoTo TimeOut
EndIf
Switch S6
   Case "1"
      GoSub FileDir
   EndCase
   Case "2"
      GoSub DownMenu
   EndCase
   Case "3"
      GoSub UpMenu
   EndCase
   Case "4"
      GoSub SysopMessage
   EndCase
   Case "5"
      GoSub LogOut
   EndCase
   Case "?"
      GoSub HelpMain
   EndCase
   Default
      Transmit "^G Invalid key was pressed.!"
   EndCase
EndSwitch
GoTo MainMenu

HelpMain:
Transmit "! ! ! ***  H E L P  ***"
Transmit "! 1. Directory of Files - displayes all the files available"
Transmit "! for download by you. Use Ctrl-S to stop the scrolling and"
Transmit "! Ctrl-Q to resume."
Transmit "!"
Transmit "! 2. Download Files - displays the Download Menu, that allows"
Transmit "! you to download available files. See this menu for additional"
Transmit "! information."
Transmit "!"
Transmit "! 3. Upload Files - displays the Upload Menu. See this menu"
Transmit "! for additional information."
Transmit "!"
Transmit "! 4. Leave a message for SYSOP - allows you to send a message"
Transmit "! to the Systems Operator. Type in the text when prompted and"
Transmit "! press Ctrl-Z when done. You have five minutes in which to"
Transmit "! enter information."
Transmit "! !Press any key ..."
If Connected
Else
   GoTo EndOfComm
EndIf
RGet S6 1 120
If Failure
   GoTo TimeOut
EndIf
Return

DownMenu:
Assign S7 "Xmodem"
DownLoop:
Transmit "! ! ! ! ! ! ! ! ! !"
Transmit "! ! ! ----- D O W N L O A D -----! !"
Transmit " 1. Directory of Files!"
Transmit " 2. Protocol("
Transmit S7
Transmit ")!"
Transmit " 3. Download a file!"
Transmit " 4. Return to MAIN MENU!"
Transmit " 5. Log Out!"
Transmit " ?. HELP! !"
Transmit " Make a selection -> "
If Connected
Else
   GoTo EndOfComm
EndIf
RGet S6 1 240
Transmit "!"
If Failure
   GoTo TimeOut
EndIf
Switch S6
   Case "1"
      GoSub FileDir
   EndCase
   Case "2"
      GoSub ChooseProtocol
   EndCase
   Case "3"
      GoSub FileDown
   EndCase
   Case "4"
      Return
   EndCase
   Case "5"
      GoSub LogOut
   EndCase
   Case "?"
      GoSub HelpDown
   EndCase
   Default
      Transmit "^G Invalid key was pressed.!"
   EndCase
EndSwitch
GoTo DownLoop

HelpDown:
Transmit "! ! ! ***  H E L P  ***"
Transmit "! 1. Directory of Files - displayes all the files available"
Transmit "! for download by you. Use Ctrl-S to stop the scrolling and"
Transmit "! Ctrl-Q to resume."
Transmit "!"
Transmit "! 2. Protocol - displays the Protocol Menu, that allows"
Transmit "! you to select the Download File Transfer mode. The mode"
Transmit "! that appears in the parentheses is the currently selected"
Transmit "! protocol. See this menu for additional information."
Transmit "!"
Transmit "! 3. Download a File - enter the name of a file to download."
Transmit "! If the file exists, you will be prompted to prepare for"
Transmit "! download. NOTE: make sure you have the proper protocol set."
Transmit "! When the transfer is complete, the Download Menu should"
Transmit "! appear."
Transmit "! !Press any key ..."
If Connected
Else
   GoTo EndOfComm
EndIf
RGet S6 1 120
If Failure
   GoTo TimeOut
EndIf
Return

UpMenu:
Assign S7 "Xmodem"
UpLoop:
Transmit "! ! ! ! ! ! ! ! ! !"
Transmit "! ! ! ----- U P L O A D -----! !"
Transmit " 1. Protocol("
Transmit S7
Transmit ")!"
Transmit " 2. Upload a file!"
Transmit " 3. Return to MAIN MENU!"
Transmit " 4. Log Out!"
Transmit " ?. HELP! !"
Transmit " Make a selection -> "
If Connected
Else
   GoTo EndOfComm
EndIf
RGet S6 1 240
Transmit "!"
If Failure
   GoTo TimeOut
EndIf
Switch S6
   Case "1"
      GoSub ChooseProtocol
   EndCase
   Case "2"
      GoSub FileUp
   EndCase
   Case "3"
      Return
   EndCase
   Case "4"
      GoSub LogOut
   EndCase
   Case "?"
      GoSub HelpUp
   EndCase
   Default
      Transmit "^G Invalid key was pressed.!"
   EndCase
EndSwitch
GoTo UpLoop

HelpUp:
Transmit "! ! ! ***  H E L P  ***"
Transmit "! 1. Protocol - displays the Protocol Menu, that allows"
Transmit "! you to select the Upload File Transfer mode. The mode"
Transmit "! that appears in the parentheses is the currently selected"
Transmit "! protocol. See this menu for additional information."
Transmit "!"
Transmit "! 2. Upload a File - enter the name of a file to upload."
Transmit "! If the file does not exist, you will be prompted to prepare"
Transmit "! for upload. NOTE: make sure you have the proper protocol set."
Transmit "! When the transfer is complete, the Upload Menu should appear."
Transmit "! !Press any key ..."
If Connected
Else
   GoTo EndOfComm
EndIf
RGet S6 1 120
If Failure
   GoTo TimeOut
EndIf
Return

ChooseProtocol:
Transmit "! ! ! ! ! ! ! ! ! !"
Transmit "! ! ! ----- P R O T O C O L -----! !"
Transmit " 1. Xmodem!"
Transmit " 2. ASCII!"
Transmit " 3. Kermit!"
Transmit " 4. Return to Previous MENU!"
Transmit " 5. Log Out!"
Transmit " ?. HELP! !"
Transmit " Current("
Transmit S7
Transmit ")! !"
Transmit " Make a selection -> "
If Connected
Else
   GoTo EndOfComm
EndIf
RGet S6 1 240
Transmit "!"
If Failure
   GoTo TimeOut
EndIf
Switch S6
   Case "1"
      Assign S7 "Xmodem"
   EndCase
   Case "2"
      Assign S7 "ASCII"
   EndCase
   Case "3"
      Assign S7 "Kermit"
   EndCase
   Case "4"
      Return
   EndCase
   Case "5"
      GoSub LogOut
   EndCase
   Case "?"
      GoSub HelpProto
   EndCase
   Default
      Transmit "^G Invalid key was pressed.!"
   EndCase
EndSwitch
GoTo ChooseProtocol

HelpProto:
Transmit "! ! ! ***  H E L P  ***"
Transmit "! 1. Xmodem - this file transfer protocol is the most widely"
Transmit "! used. Used for binary files (ARC,COM,EXE) as well as text"
Transmit "! (TXT,DOC) files. Data is sent in Blocks."
Transmit "!"
Transmit "! 2. ASCII - this file transfer protocol is used to send text"
Transmit "! files (TXT,DOC) ONLY. It cannot transfer binary (ARC,COM,EXE)"
Transmit "! files."
Transmit "!"
Transmit "! 3. Kermit - this file transfer protocol is used for binary"
Transmit "! (ARC,COM,EXE) as well as text (TXT,DOC) files. Data is sent"
Transmit "! in Packets."
Transmit "! !Press any key ..."
If Connected
Else
   GoTo EndOfComm
EndIf
RGet S6 1 120
If Failure
   GoTo TimeOut
EndIf
Return

FileDir:
;
; this routine looks for "BBSDIR.TXT" in the current directory.
; If it is found, the file is sent as an ASCII upload. This
; file, not included in the .ARChive, contains the names of the
; files that users can download.
;
IsFile "BBSDIR.TXT"
If Failure
   Transmit "!Directory not available at this time."
Else
   Transmit "! !Directory of Files!"
   Send ASCII "BBSDIR.TXT"
   Transmit "!Press any key ..."
   If Connected
   Else
      GoTo EndOfComm
   EndIf
   RGet S6 1 120
   If Failure
      GoTo TimeOut
   EndIf
EndIf
Return

FileDown:
;
; this routine prompts the user for a filename.ext. If it is found,
; the user is prompted to prepare for download and to press RETURN
; when ready. The current protocol is used for transfer. The default
; protocol is Xmodem. After the transfer is complete, the program is
; returned to the calling procedure.
;
Transmit "! !Enter the filename to download!-> "
If Connected
Else
   GoTo EndOfComm
EndIf
RGet S6 12 120
If Failure
   GoTo TimeOut
EndIf
IsFile S6
If Failure
   Transmit "!^G!FILE NOT FOUND!Press any key ..."
   If Connected
   Else
      GoTo EndOfComm
   EndIf
   RGet S6 1 120
   If Failure
      GoTo TimeOut
   EndIf
   Return
EndIf
Transmit "!Prepare for download and press <CR> when ready.!"
Transmit "Process will abort if not started in one minute. "
WaitFor "^M" 120
If WaitFor
Else
   GoTo TimeOut
EndIf
Switch S7
   Case "Xmodem"
      SendFile Xmodem S6
   EndCase
   Case "ASCII"
      SendFile ASCII S6
   EndCase
   Case "Kermit"
      SendFile Kermit S6
   EndCase
EndSwitch
Return

FileUp:
;
; this routine prompts the user for a filename.ext. If it is NOT found,
; the user is prompted to prepare for upload and to press RETURN
; when ready. The current protocol is used for transfer. The default
; protocol is Xmodem. After the transfer is complete, the program is
; returned to the calling procedure.
;
Transmit "! !Enter the filename to upload!-> "
If Connected
Else
   GoTo EndOfComm
EndIf
RGet S6 12 120
If Failure
   GoTo TimeOut
EndIf
IsFile S6
If Success
   Transmit "!^G!FILE ALREADY EXISTS!Press any key ..."
   If Connected
   Else
      GoTo EndOfComm
   EndIf
   RGet S6 1 120
   If Failure
      GoTo TimeOut
   EndIf
   Return
EndIf
Transmit "!Prepare for upload and press <CR> when ready.!"
Transmit "Process will abort if not started in one minute. "
WaitFor "^M" 120
If WaitFor
Else
   GoTo TimeOut
EndIf
Switch S7
   Case "Xmodem"
      GetFile Xmodem S6
   EndCase
   Case "ASCII"
      GetFile ASCII S6
   EndCase
   Case "Kermit"
      GetFile Kermit S6
   EndCase
EndSwitch
Return

LogOut:
Transmit "!Are you sure you want to LOG OUT ? <Y/N> "
If Connected
Else
   GoTo EndOfComm
EndIf
RGet S6 1 30
If Failure
   GoTo TimeOut
EndIf
Find S6 "Y"
If Found
   Transmit "! !"
   Transmit S5
   Transmit "Logging out. Disconnecting ..."
   GoTo EndOfComm
EndIf
Return

SysopMessage:
Transmit "! !Do you wish to leave a message ? <Y/N> "
If Connected
Else
   GoTo EndOfComm
EndIf
RGet S6 1 60
If Failure
   GoTo TimeOut
EndIf
Find S6 "Y"
If Found
   Transmit "! !Enter your message below. Press Ctrl-Z when done.!"
   Transmit "You have five minutes!"
   If Connected
   Else
      GoTo EndOfComm
   EndIf
   Log Open "BBSMESG.TXT"
   WaitFor "^Z" 540
   Transmit "!Message saved!"
   Log Close
EndIf
Return

TimeOut:
Transmit "^G! ! !Time Out has occurred. Disconnecting ..."

EndOfComm:
Hangup
GoTo StartOfSession
